local assets=
{
	Asset("ANIM", "anim/fireball.zip"),
	Asset("IMAGE", "images/inventoryimages/fireball.tex"),
	Asset("ATLAS", "images/inventoryimages/fireball.xml"),
}


local function onequip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_body", "fireball", "swap_body")
	owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale - 1

end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale + 1

end


local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    	
    inst.AnimState:SetBank("fireball")
    inst.AnimState:SetBuild("fireball")
    inst.AnimState:PlayAnimation("idle", false)
    	
    inst:AddComponent("inspectable")
	
	inst:AddTag("backpack")

	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fireball.xml"
 
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 15
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)
    inst.components.insulator:SetSummer()
	
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
		
    return inst
end

return Prefab( "common/inventory/fireball", fnab, assets) 